<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Portfolio Website - Showcase your work, education, and achievements">
    <meta name="author" content="Portfolio">
    <title><?= esc($title ?? 'Portfolio') ?></title>
    
    <!-- Preconnect for performance -->
    <link rel="preconnect" href="https://cdn.jsdelivr.net">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    
    <!-- 🎨 Custom CSS - Ultra Modern Design -->
    <link rel="stylesheet" href="<?= base_url('assets/css/style.css') ?>">
    <link rel="stylesheet" href="<?= base_url('assets/css/glassmorphism.css') ?>">
    <link rel="stylesheet" href="<?= base_url('assets/css/image-modal.css') ?>">
    
    <?= $this->renderSection('styles') ?>
    
    <style>
        /* 💙 Bright Blue Loading Screen with Network Animation */
        #page-loader {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, #F0F8FF 0%, #E6F3FF 100%);
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            z-index: 99999;
            transition: opacity 0.8s ease;
            overflow: hidden;
        }
        
        /* Elegant Blue Network Background Animation */
        #page-loader::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: 
                radial-gradient(circle at 25% 25%, rgba(135, 206, 235, 0.2) 2px, transparent 2px),
                radial-gradient(circle at 75% 25%, rgba(65, 105, 225, 0.2) 2px, transparent 2px),
                radial-gradient(circle at 25% 75%, rgba(135, 206, 235, 0.2) 2px, transparent 2px),
                radial-gradient(circle at 75% 75%, rgba(65, 105, 225, 0.2) 2px, transparent 2px);
            background-size: 100px 100px;
            animation: networkMove 8s linear infinite;
            opacity: 0.8;
        }
        
        /* Network Lines */
        #page-loader::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: 
                linear-gradient(45deg, transparent 48%, rgba(135, 206, 235, 0.15) 49%, rgba(135, 206, 235, 0.15) 51%, transparent 52%),
                linear-gradient(-45deg, transparent 48%, rgba(65, 105, 225, 0.15) 49%, rgba(65, 105, 225, 0.15) 51%, transparent 52%);
            background-size: 50px 50px;
            animation: networkPulse 4s ease-in-out infinite;
            opacity: 0.5;
        }
        
        @keyframes networkMove {
            0% { transform: translate(0, 0); }
            25% { transform: translate(-10px, -10px); }
            50% { transform: translate(10px, -5px); }
            75% { transform: translate(-5px, 10px); }
            100% { transform: translate(0, 0); }
        }
        
        @keyframes networkPulse {
            0%, 100% { opacity: 0.5; }
            50% { opacity: 0.8; }
        }
        
        .loader-content {
            text-align: center;
            color: #1E3A8A;
            position: relative;
            z-index: 2;
        }
        
        .loader-spinner {
            width: 80px;
            height: 80px;
            border: 3px solid rgba(135, 206, 235, 0.3);
            border-top: 3px solid #4169E1;
            border-right: 3px solid #87CEEB;
            border-radius: 50%;
            animation: spin 1.5s linear infinite;
            margin: 0 auto 30px;
            position: relative;
        }
        
        .loader-spinner::before {
            content: '';
            position: absolute;
            top: 5px;
            left: 5px;
            right: 5px;
            bottom: 5px;
            border: 2px solid transparent;
            border-top: 2px solid rgba(65, 105, 225, 0.6);
            border-radius: 50%;
            animation: spin 1s linear infinite reverse;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .loader-text {
            font-size: 1.4rem;
            font-weight: 600;
            color: #1E3A8A;
            margin-top: 20px;
            text-shadow: 0 0 10px rgba(65, 105, 225, 0.3);
        }
        
        /* 🎬 Smooth page transitions */
        main {
            animation: fadeInUp 0.6s ease-out;
        }
    </style>
</head>
<body>
    <!-- Canvas Particles Background -->
    <canvas id="star-canvas" style="position: fixed; top: 0px; left: 0px; width: 100%; height: 100%; z-index: -2; pointer-events: none;"></canvas>
    <canvas id="particle-canvas" style="position: fixed; top: 0px; left: 0px; width: 100%; height: 100%; z-index: -1; pointer-events: none;"></canvas>
    
    <!-- Loading Screen -->
    <div id="page-loader">
        <div class="loader-content">
            <div class="loader-spinner"></div>
            <div class="loader-text">
                <i class="bi bi-stars me-2"></i>Tunggu sebentar yahh..
            </div>
        </div>
    </div>
    

    
    <!-- Navbar -->
    <?= $this->include('components/navbar') ?>
    
    <!-- Main Content -->
    <main>
        <?= $this->renderSection('content') ?>
    </main>
    
    <!-- Footer -->
    <?= $this->include('components/footer') ?>
    

    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- 🎨 Custom JS - Ultra Modern Interactions -->
    <script src="<?= base_url('assets/js/canvas-particles.js') ?>"></script>
    <script src="<?= base_url('assets/js/navbar-fix.js') ?>"></script>
    <script src="<?= base_url('assets/js/interactions.js') ?>"></script>
    
    <?= $this->renderSection('scripts') ?>
    
    <script>
        // 🎪 Single Loading Screen - No Double Loading
        let loadingComplete = false;
        
        window.addEventListener('load', function() {
            if (loadingComplete) return;
            loadingComplete = true;
            
            const loader = document.getElementById('page-loader');
            setTimeout(() => {
                loader.style.opacity = '0';
                setTimeout(() => {
                    loader.style.display = 'none';
                    document.body.classList.add('loaded');
                }, 800);
            }, 1200);
        });
        
        // 💙 Simple Scroll Effects (No Progress Bar)
        window.addEventListener('scroll', function() {
            // Parallax effect for floating shapes only
            const shapes = document.querySelectorAll('.floating-shapes .shape');
            const currentScroll = window.scrollY;
            shapes.forEach((shape, index) => {
                const speed = 0.5 + (index * 0.1);
                const yPos = -(currentScroll * speed);
                shape.style.transform = `translateY(${yPos}px)`;
            });
        });
        
        // 💙 Scroll-based content animations
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        };
        
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.classList.add('visible');
                }
            });
        }, observerOptions);
        
        // Observe elements for scroll animations
        document.addEventListener('DOMContentLoaded', function() {
            const animateElements = document.querySelectorAll('.card, .section-title, .search-filter-section');
            animateElements.forEach(el => {
                el.classList.add('scroll-fade-in');
                observer.observe(el);
            });
        });
        

        
        // 🎨 Navbar Dropdown Enhancement
        document.querySelectorAll('.navbar-nav .dropdown').forEach(dropdown => {
            dropdown.addEventListener('mouseenter', function() {
                if (window.innerWidth > 991) {
                    this.querySelector('.dropdown-menu').classList.add('show');
                }
            });
            
            dropdown.addEventListener('mouseleave', function() {
                if (window.innerWidth > 991) {
                    this.querySelector('.dropdown-menu').classList.remove('show');
                }
            });
        });
        
        // ✨ Add sparkle effect on important elements
        function createSparkle(x, y) {
            const sparkle = document.createElement('div');
            sparkle.className = 'sparkle';
            sparkle.style.left = x + 'px';
            sparkle.style.top = y + 'px';
            sparkle.innerHTML = '✨';
            document.body.appendChild(sparkle);
            
            setTimeout(() => sparkle.remove(), 1000);
        }
        
        // Add sparkle CSS with bright blue theme
        const sparkleStyle = document.createElement('style');
        sparkleStyle.textContent = `
            .sparkle {
                position: fixed;
                pointer-events: none;
                font-size: 20px;
                animation: sparkleFloat 1s ease-out forwards;
                z-index: 9999;
                color: #4169E1;
            }
            
            @keyframes sparkleFloat {
                0% {
                    transform: translateY(0) scale(0);
                    opacity: 1;
                }
                100% {
                    transform: translateY(-50px) scale(1);
                    opacity: 0;
                }
            }
        `;
        document.head.appendChild(sparkleStyle);
        
        // Add sparkles on button clicks
        document.querySelectorAll('.btn, .glass-btn, .glass-btn-primary').forEach(btn => {
            btn.addEventListener('click', function(e) {
                createSparkle(e.clientX, e.clientY);
            });
        });
        
        // 🎯 Performance Monitor (Development Only)
        if (window.location.hostname === 'localhost' || window.location.hostname === '127.0.0.1') {
            let fps = 0;
            let lastTime = performance.now();
            
            function measureFPS() {
                const currentTime = performance.now();
                fps = Math.round(1000 / (currentTime - lastTime));
                lastTime = currentTime;
                requestAnimationFrame(measureFPS);
            }
            
            measureFPS();
            
            // Show FPS counter with bright blue theme
            const fpsCounter = document.createElement('div');
            fpsCounter.style.cssText = `
                position: fixed;
                bottom: 10px;
                left: 10px;
                background: rgba(255, 255, 255, 0.9);
                color: #4169E1;
                padding: 5px 10px;
                border-radius: 5px;
                font-size: 12px;
                font-family: monospace;
                z-index: 99999;
                border: 1px solid rgba(65, 105, 225, 0.3);
            `;
            document.body.appendChild(fpsCounter);
            
            setInterval(() => {
                fpsCounter.textContent = `FPS: ${fps}`;
            }, 100);
        }
    </script>
    
    <!-- Image Modal for Full View -->
    <div class="modal fade" id="imageModal" tabindex="-1" aria-labelledby="imageModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content" style="background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(20px); border: 1px solid rgba(135, 206, 235, 0.3); border-radius: 16px;">
                <div class="modal-header" style="border-bottom: 1px solid rgba(135, 206, 235, 0.3);">
                    <h5 class="modal-title" style="color: #1E3A8A;" id="imageModalLabel">Lihat Gambar</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="filter: invert(1);"></button>
                </div>
                <div class="modal-body text-center p-0">
                    <img id="modalImage" src="" alt="" class="img-fluid w-100" style="max-height: 80vh; object-fit: contain; border-radius: 8px;">
                </div>
                <div class="modal-footer" style="border-top: 1px solid rgba(135, 206, 235, 0.3); justify-content: center;">
                    <button type="button" class="btn" style="background: linear-gradient(135deg, #87CEEB, #4169E1); color: white; border: none; border-radius: 25px;" onclick="downloadImage()">
                        <i class="bi bi-download me-1"></i>Download
                    </button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" style="background: rgba(135, 206, 235, 0.2); color: #1E3A8A; border: 1px solid rgba(135, 206, 235, 0.3); border-radius: 25px;">Tutup</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Video Modal for Full View -->
    <div class="modal fade" id="videoModal" tabindex="-1" aria-labelledby="videoModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered">
            <div class="modal-content" style="background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(20px); border: 1px solid rgba(135, 206, 235, 0.3); border-radius: 16px;">
                <div class="modal-header" style="border-bottom: 1px solid rgba(135, 206, 235, 0.3);">
                    <h5 class="modal-title" style="color: #1E3A8A;" id="videoModalLabel">Putar Video</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="filter: invert(1);"></button>
                </div>
                <div class="modal-body text-center p-0">
                    <video id="modalVideo" controls class="w-100" style="max-height: 80vh; border-radius: 8px;">
                        <source id="modalVideoSource" src="" type="video/mp4">
                        Browser Anda tidak mendukung video HTML5.
                    </video>
                </div>
                <div class="modal-footer" style="border-top: 1px solid rgba(135, 206, 235, 0.3); justify-content: center;">
                    <button type="button" class="btn" style="background: linear-gradient(135deg, #87CEEB, #4169E1); color: white; border: none; border-radius: 25px;" onclick="downloadVideo()">
                        <i class="bi bi-download me-1"></i>Download
                    </button>
                    <button type="button" class="btn" style="background: linear-gradient(135deg, #FFB6C1, #FF69B4); color: white; border: none; border-radius: 25px;" onclick="toggleFullscreen()">
                        <i class="bi bi-fullscreen me-1"></i>Fullscreen
                    </button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" style="background: rgba(135, 206, 235, 0.2); color: #1E3A8A; border: 1px solid rgba(135, 206, 235, 0.3); border-radius: 25px;">Tutup</button>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        // Image Modal Functions
        function showImageModal(imageUrl, altText) {
            const modal = new bootstrap.Modal(document.getElementById('imageModal'));
            const modalImage = document.getElementById('modalImage');
            const modalTitle = document.getElementById('imageModalLabel');
            
            modalImage.src = imageUrl;
            modalImage.alt = altText || 'Gambar';
            modalTitle.textContent = altText || 'Lihat Gambar';
            
            modal.show();
        }
        
        function downloadImage() {
            const modalImage = document.getElementById('modalImage');
            const link = document.createElement('a');
            link.href = modalImage.src;
            link.download = modalImage.alt || 'image';
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        }

        // Video Modal Functions
        function showVideoModal(videoUrl, title) {
            const modal = new bootstrap.Modal(document.getElementById('videoModal'));
            const modalVideo = document.getElementById('modalVideo');
            const modalVideoSource = document.getElementById('modalVideoSource');
            const modalTitle = document.getElementById('videoModalLabel');
            
            // Stop any currently playing video
            modalVideo.pause();
            modalVideo.currentTime = 0;
            
            // Set new video source
            modalVideoSource.src = videoUrl;
            modalVideo.load(); // Reload video with new source
            modalTitle.textContent = title || 'Putar Video';
            
            modal.show();
            
            // Auto play when modal is shown
            setTimeout(() => {
                modalVideo.play().catch(e => {
                    console.log('Auto-play prevented by browser:', e);
                });
            }, 500);
        }
        
        function downloadVideo() {
            const modalVideoSource = document.getElementById('modalVideoSource');
            const link = document.createElement('a');
            link.href = modalVideoSource.src;
            link.download = 'video';
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        }
        
        function toggleFullscreen() {
            const modalVideo = document.getElementById('modalVideo');
            
            if (modalVideo.requestFullscreen) {
                modalVideo.requestFullscreen();
            } else if (modalVideo.webkitRequestFullscreen) {
                modalVideo.webkitRequestFullscreen();
            } else if (modalVideo.msRequestFullscreen) {
                modalVideo.msRequestFullscreen();
            }
        }

        // Pause video when modal is closed
        document.getElementById('videoModal').addEventListener('hidden.bs.modal', function () {
            const modalVideo = document.getElementById('modalVideo');
            modalVideo.pause();
            modalVideo.currentTime = 0;
        });
        
        // Add click handlers to all images with image-clickable class
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.image-clickable').forEach(img => {
                img.style.cursor = 'pointer';
                img.addEventListener('click', function() {
                    const fullImageUrl = this.dataset.fullImage || this.src;
                    const altText = this.alt || 'Gambar';
                    showImageModal(fullImageUrl, altText);
                });
            });
        });
    </script>
</body>
</html>

